/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp3;

import com.google.common.collect.Lists;
import cz.insophy.inplan.mrp3.Balancer;
import cz.insophy.inplan.mrp3.CreatedSupplyHandler;
import cz.insophy.inplan.mrp3.Demand;
import cz.insophy.inplan.mrp3.DemandsCollector;
import cz.insophy.inplan.mrp3.Events;
import cz.insophy.inplan.mrp3.SuppliesCollector;
import cz.insophy.inplan.mrp3.SuppliesCreator;
import cz.insophy.inplan.mrp3.Supply;
import cz.insophy.inplan.mrp3.UnnecessarySuppliesHandler;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class DefaultBalancer
implements Balancer {
    private final SuppliesCollector suppliesCollector;
    private final DemandsCollector demandsCollector;
    private final SuppliesCreator suppliesCreator;
    private final CreatedSupplyHandler createdSupplyHandler;
    private final UnnecessarySuppliesHandler unnecessarySuppliesHandler;

    public DefaultBalancer(SuppliesCollector suppliesCollector, DemandsCollector demandsCollector, SuppliesCreator suppliesCreator, CreatedSupplyHandler createdSupplyHandler, UnnecessarySuppliesHandler unnecessarySuppliesHandler) {
        this.suppliesCollector = suppliesCollector;
        this.demandsCollector = demandsCollector;
        this.suppliesCreator = suppliesCreator;
        this.createdSupplyHandler = createdSupplyHandler;
        this.unnecessarySuppliesHandler = unnecessarySuppliesHandler;
    }

    @Override
    public Tuple<Collection<Supply>, Events> balanceMaterial(Superplan superplan, Material m3, Events events) {
        ArrayList<Demand> newDemands = Lists.newArrayList();
        ArrayList<Supply> newSupplies = Lists.newArrayList();
        Pairer p = new Pairer(this.suppliesCollector.collectSupplies(superplan, m3, events.supplies), this.demandsCollector.collectDemands(superplan, m3, events.demands));
        p.pairAll();
        Collection<Object> supplies = Collections.emptyList();
        if (p.hasMoreDemands()) {
            supplies = this.suppliesCreator.createSupplies(p.dem, p.demQty, p.demands);
            for (Supply supply : supplies) {
                Events newEvents = this.createdSupplyHandler.handle(supply);
                newSupplies.addAll(newEvents.supplies);
                newDemands.addAll(newEvents.demands);
            }
            p.supplies = supplies.iterator();
            p.pairAll();
            if (p.hasMoreDemands()) {
                throw new IllegalStateException("Invalid supplies created.");
            }
        }
        if (p.hasMoreSupplies()) {
            this.unnecessarySuppliesHandler.handleUnnecessarySupplies(p.sup, p.supQty, p.supplies);
        }
        return Tuple.create(supplies, new Events(newSupplies, newDemands));
    }

    protected void pair(Supply sup, Demand dem, double qty) {
        System.out.printf("Sending %f from %s to %s\n", qty, sup, dem);
    }

    private class Pairer {
        Iterator<Supply> supplies;
        Iterator<Demand> demands;
        Supply sup = null;
        Demand dem = null;
        double supQty = 0.0;
        double demQty = 0.0;

        private Pairer(Iterable<Supply> supplies, Iterable<Demand> demands) {
            this.supplies = supplies.iterator();
            this.demands = demands.iterator();
        }

        private void pairAll() {
            while (true) {
                if (this.supQty <= 1.0E-7) {
                    if (this.supplies.hasNext()) {
                        this.sup = this.supplies.next();
                        this.supQty = this.sup.getQty();
                    } else {
                        this.supplies = null;
                        this.sup = null;
                    }
                }
                if (this.demQty <= 1.0E-7) {
                    if (this.demands.hasNext()) {
                        this.dem = this.demands.next();
                        this.demQty = this.dem.getQty();
                    } else {
                        this.demands = null;
                        this.dem = null;
                    }
                }
                if (this.sup == null || this.dem == null) break;
                double qty = Math.min(this.supQty, this.demQty);
                this.supQty -= qty;
                this.demQty -= qty;
                DefaultBalancer.this.pair(this.sup, this.dem, qty);
            }
        }

        private boolean hasMoreDemands() {
            return this.demQty > 1.0E-7;
        }

        private boolean hasMoreSupplies() {
            return this.supQty > 1.0E-7;
        }
    }
}

